/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.math;

public final class MathUtil {
    private static volatile float[] SINE_TABLE;
    public static final float PI = (float)Math.PI;
    public static final float PI_DIV_2 = 1.5707964f;
    public static final float PI_DIV_3 = 1.0471976f;
    public static final float PI_DIV_4 = 0.7853982f;
    public static final float PI_DIV_6 = 0.5235988f;
    public static final float TWO_PI = (float)Math.PI * 2;
    public static final float THREE_PI_DIV_2 = 4.712389f;

    public static synchronized void initSineTable() {
        if (SINE_TABLE == null) {
            float[] v = new float[65536];
            for (int i = 0; i < 65536; ++i) {
                v[i] = (float)Math.sin((double)i * 9.587379924285257E-5);
            }
            SINE_TABLE = v;
        }
    }

    public static float fsin(float a) {
        return SINE_TABLE[Math.round(a * 10430.378f) & 0xFFFF];
    }

    public static float fcos(float a) {
        return SINE_TABLE[Math.round(a * 10430.378f) + 16384 & 0xFFFF];
    }

    public static float sin(float a) {
        return (float)Math.sin(a);
    }

    public static float cos(float a) {
        return (float)Math.cos(a);
    }

    public static float tan(float a) {
        return (float)Math.tan(a);
    }

    public static boolean exactlyEqual(float a, float b) {
        return Float.floatToIntBits(a) == Float.floatToIntBits(b);
    }

    public static boolean approxEqual(float a, float b) {
        return a == b || Math.abs(b - a) < 1.0E-6f;
    }

    public static boolean approxEqual(float a, float b, float c, float z) {
        return MathUtil.approxEqual(a, z) && MathUtil.approxEqual(b, z) && MathUtil.approxEqual(c, z);
    }

    public static boolean approxEqual(float a, float b, float c, float d, float z) {
        return MathUtil.approxEqual(a, z) && MathUtil.approxEqual(b, z) && MathUtil.approxEqual(c, z) && MathUtil.approxEqual(d, z);
    }

    public static boolean isEqual(float a, float b, float eps) {
        return Math.abs(b - a) < eps;
    }

    public static boolean approxZero(float a) {
        return a == 0.0f || Math.abs(a) < 1.0E-6f;
    }

    public static boolean approxZero(float a, float b, float c) {
        return MathUtil.approxZero(a) && MathUtil.approxZero(b) && MathUtil.approxZero(c);
    }

    public static boolean isZero(float a, float eps) {
        return Math.abs(a) < eps;
    }

    public static float sqrt(float f) {
        return (float)Math.sqrt(f);
    }

    public static float fastInvSqrt(float a) {
        float x2 = 0.5f * a;
        int i = Float.floatToIntBits(a);
        i = 1597463007 - (i >> 1);
        a = Float.intBitsToFloat(i);
        a *= 1.5f - x2 * a * a;
        return a;
    }

    public static double fastInvSqrt(double a) {
        double x2 = 0.5 * a;
        long i = Double.doubleToLongBits(a);
        i = 6910469410427058089L - (i >> 1);
        a = Double.longBitsToDouble(i);
        a *= 1.5 - x2 * a * a;
        return a;
    }

    public static float asin(float a) {
        return (float)Math.asin(a);
    }

    public static float acos(float a) {
        return (float)Math.acos(a);
    }

    public static float atan2(float a, float b) {
        return (float)Math.atan2(a, b);
    }
}

